GoatManager = GoatManager or class()
GoatManager.HEIGHT = Vector3(0,0,100)
GoatManager.MASS_CENTER = 40
GoatManager.ANIM_DATA = {
	anim_walk_fwd = {0,1},
	anim_back = {0,1},
	anim_right_strafe = {0,1},
	anim_left_strafe = {0,1},
	anim_sprint = {0,1},
	startup = {0,1},
	anim_attack_head = {0.7,2},
	anim_attack_feet = {1.1,2},
}
function GoatManager:init()
	self.brush = Draw:brush(Color(0.8, 220/255, 20/255, 60/255))
	self._rot_p = 0
end
function GoatManager:update(t, dt)
end
function GoatManager:unit()
	return self._unit
end
function GoatManager:spawn_unit(parent)
	local _locke = World:spawn_unit(Idstring("units/pd2_dlc_berry/characters/npc_locke/npc_locke"), parent:position(), Rotation())
	parent:link(parent:orientation_object():name(), _locke, _locke:orientation_object():name())
	_locke:set_slot(2)
	self._unit = _locke
	self._unit:movement():set_team(managers.groupai:state():team_data(tweak_data.levels:get_default_team_ID("combatant")))
	self._unit:brain():set_active(true, true)
	self._unit:character_damage():set_invulnerable(true)
	self._unit:contour():add("friendly")
	self._parent_unit = parent
end
function GoatManager:parent()
	return self._parent_unit
end
function GoatManager:do_melee_attack(t)
	local melee_weapon = self._unit:base():melee_weapon()
	local is_weapon = melee_weapon == "weapon"
	local state = self._unit:movement():play_redirect(is_weapon and "melee" or "melee_item")
	if state then
		if not is_weapon then
			local anim_attack_vars = {"var1", "var2"}
			self._unit:anim_state_machine():set_parameter(state, anim_attack_vars[math.random(#anim_attack_vars)], 1)
			local param = tweak_data.weapon.npc_melee[melee_weapon].animation_param
			self._unit:anim_state_machine():set_parameter(state, param, 1)
		end
		if is_weapon then
			local anim_speed = 1
			self._unit:anim_state_machine():set_speed(state, anim_speed)
		end
		self._melee_timeout_t = TimerManager:game():time() + 1
	end
end
function GoatManager:delete_unit()
	if self:unit_alive() then
		World:delete_unit(self._unit)
	end
end
function GoatManager:unit_alive()
	if alive(self._unit) then
		return true
	end
end
function GoatManager:set_rotation(rot)
	if self:can_walk() then
		self._unit:set_rotation(Rotation(rot:yaw(), 0, rot:roll()))
	end
end
function GoatManager:get_body_position()
	if self:unit_alive() then
		return self._unit:body(0):position() + Vector3(0,0,20)
	end
end

function GoatManager:stop_sound()
	if not self:unit_alive() then
		return
	end
	self._unit:sound_source():stop()
end
function GoatManager:play_seq(seq)
	if not self:unit_alive() then
		return
	end
	self._unit:movement():play_redirect(seq)
end
function GoatManager:anim_leng(anim)
	local d = GoatManager.ANIM_DATA[anim]
	return d and d[1]
end
function GoatManager:anim_type(anim)
	local d = GoatManager.ANIM_DATA[anim]
	return d and d[2]
end
--
function GoatManager:set_rotation(rot)
	if self:can_walk() then
		self._unit:set_rotation(Rotation(rot:yaw(), self._rot_p, rot:roll()))
		local plr_rot = managers.player:player_unit():movement():m_head_rot()
		local p_rot = Rotation(plr_rot:yaw(), 0, plr_rot:roll())
		self._unit:set_position(managers.player:player_unit():position() - p_rot:z() * (math.cos(self._rot_p) * GoatManager.MASS_CENTER - GoatManager.MASS_CENTER) + p_rot:y() * math.sin(self._rot_p) * GoatManager.MASS_CENTER)
	end
end
function GoatManager:set_pitch(p)
	self._rot_p = p % 360
end
function GoatManager:add_pitch(p)
	self._rot_p = (self._rot_p + p) % 360
end
function GoatManager:pitch()
	return self._rot_p
end
--
function GoatManager:can_walk()
	if alive(self._unit) and not self._ragdoll then
		return true
	end
end
function GoatManager:ragdoll_velocity()
	local vel = self._unit:body(7):velocity()
	return mvector3.length(vel)
end
function GoatManager:update_ragdoll_velocity(vel)
	if self:ragdoll_velocity() < vel then
		self:revive()
	end
end
function GoatManager:is_ragdoll()
	return self._ragdoll
end
function GoatManager:switch_ragdoll()
	if not self:unit_alive() then
		return
	end
	if self:is_ragdoll() then
		self:revive()
	else
		self:ragdoll()
	end
end
function GoatManager:switch_ragdoll_vel()
	if not self:unit_alive() then
		return
	end
	if self:is_ragdoll() then
		self:update_ragdoll_velocity(50)
	else
		self:ragdoll()
	end
end
function GoatManager:ragdoll()
	return
end
function GoatManager:revive()
	for i = 0, self._unit:num_bodies() - 1 do
		self._unit:body(i):set_enabled(i < 2)
	end
	self:play_seq("idle")
	self._ragdoll = false
	self:drop()
	
	local player_unit = managers.player:player_unit()
	if alive(player_unit) then
		player_unit:movement():set_position(self._unit:body(0):position())
	end
end
--
function GoatManager:grab(col_ray)
	return
end
function GoatManager:drop()
	return
end
function GoatManager:grabbing()
	return
end
local function get_mass(body)
	local total_mass = 0
	for i = 0, body:unit():num_bodies() - 1 do
		total_mass = total_mass + body:unit():body(i):mass()
	end
	return total_mass
end
local init = PlayerManager.init
function PlayerManager:init()
	init(self)
	self.locke = GoatManager:new()
end